import { Repository } from 'typeorm';
import { Vendor } from '../../entities/vendor.entity';
import { Product } from '../../entities/product.entity';
import { Category } from '../../entities/category.entity';
import { CreateVendorDto } from './dto/create-vendor.dto';
import { CreateVendorProductDto } from './dto/create-vendor-products.dto';
import { UpdateVendorProfileDto } from './dto/update-vendor-profile.dto';
import { VendorResponseDto } from './dto/vendor-response.dto';
import { VendorQueryDto } from './dto/vendor-query.dto';
export declare class VendorsService {
    private readonly vendorRepo;
    private readonly productRepo;
    private readonly categoryRepo;
    constructor(vendorRepo: Repository<Vendor>, productRepo: Repository<Product>, categoryRepo: Repository<Category>);
    private toVendorResponseDto;
    create(createVendorDto: CreateVendorDto): Promise<VendorResponseDto>;
    findAll(query: VendorQueryDto): Promise<{
        vendors: VendorResponseDto[];
        total: number;
        page: number;
        limit: number;
        totalPages: number;
    }>;
    findOne(id: string): Promise<VendorResponseDto>;
    findByEmail(email: string): Promise<VendorResponseDto>;
    findByIds(ids: string[]): Promise<VendorResponseDto[]>;
    update(id: string, updateVendorDto: UpdateVendorProfileDto): Promise<VendorResponseDto>;
    remove(id: string): Promise<void>;
    approveVendor(id: string): Promise<VendorResponseDto>;
    rejectVendor(id: string): Promise<VendorResponseDto>;
    toggleActive(id: string): Promise<VendorResponseDto>;
    updateRating(id: string, newRating: number): Promise<VendorResponseDto>;
    getVendorProducts(id: string): Promise<any[]>;
    createVendorProduct(vendorId: string, createProductDto: CreateVendorProductDto): Promise<any>;
    getVendorProductById(vendorId: string, productId: number): Promise<any>;
    updateVendorProduct(vendorId: string, productId: number, updateProductDto: CreateVendorProductDto): Promise<any>;
    deleteVendorProduct(vendorId: string, productId: number): Promise<void>;
    getVendorOrders(vendorId: string, query?: any): Promise<any>;
    getVendorDashboard(vendorId: string): Promise<any>;
    getVendorStats(id: string): Promise<{
        totalProducts: number;
        featuredProducts: number;
        outOfStockProducts: number;
        lowStockProducts: number;
        totalRevenue: number;
        rating: number;
        isApproved: boolean;
        isActive: boolean;
    }>;
    getPendingVendors(): Promise<VendorResponseDto[]>;
    getTopVendors(limit?: number): Promise<VendorResponseDto[]>;
    searchVendors(searchTerm: string, limit?: number): Promise<VendorResponseDto[]>;
    getVendorsByLocation(city?: string, state?: string, country?: string): Promise<VendorResponseDto[]>;
}
